<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// Include config.php to get database credentials
include('config.php');

// Check if the user is logged in
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: filthydog12.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = $_POST['site_status'] == 'enabled' ? 'enabled' : 'disabled';

    // Update the database with the new status
    try {
        // Use the credentials from config.php
        $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = :status WHERE setting_name = 'site_status'");
        $stmt->execute(['status' => $new_status]);
        $success_message = "Website status updated to $new_status!";
    } catch (PDOException $e) {
        $error_message = "Error updating status: " . $e->getMessage();
    }
}

// Fetch the current status to display
try {
    // Use the credentials from config.php
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    $status_query = $pdo->query("SELECT setting_value FROM settings WHERE setting_name = 'site_status'");
    $site_status = $status_query->fetchColumn();
} catch (PDOException $e) {
    $error_message = "Error fetching status: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Website Status</title>
</head>
<body>
    <h1>Current Website Status: <?php echo $site_status; ?></h1>

    <?php if (isset($success_message)): ?>
        <p style="color: green;"><?php echo $success_message; ?></p>
    <?php elseif (isset($error_message)): ?>
        <p style="color: red;"><?php echo $error_message; ?></p>
    <?php endif; ?>

    <form method="POST">
        <label for="site_status">Update Website Status:</label>
        <select name="site_status" id="site_status">
            <option value="enabled" <?php echo ($site_status === 'enabled') ? 'selected' : ''; ?>>Enabled</option>
            <op

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Website Status</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #eef2f6;
            font-family: 'Roboto', sans-serif;
            transition: background-color 0.3s, color 0.3s;
        }
        .admin-panel {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            padding: 40px;
            max-width: 450px;
            margin: 50px auto;
            transition: background 0.3s, box-shadow 0.3s;
        }
        h1 {
            font-size: 26px;
            color: #333;
            margin-bottom: 20px;
            text-align: center;
        }
        .status-message {
            color: green;
            margin-bottom: 15px;
        }
        .error-message {
            color: red;
            margin-bottom: 15px;
        }
        .form-check-label {
            margin-left: 10px;
        }
        button {
            background-color: #007bff;
            border: none;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #0056b3;
        }
        /* Dark mode styles */
        body.dark-mode {
            background-color: #181818;
            color: #e0e0e0;
        }
        body.dark-mode .admin-panel {
            background: #282828;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        body.dark-mode h1 {
            color: #f0f0f0;
        }
        body.dark-mode .status-message {
            color: #81c784; /* Light green for success message */
        }
        body.dark-mode .error-message {
            color: #e57373; /* Light red for error message */
        }
        body.dark-mode button {
            background-color: #007bff;
        }
        body.dark-mode button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="admin-panel">
        <h1>Website Status</h1>
        <?php if (isset($success_message)): ?>
            <div class="alert alert-success status-message">
                <?= htmlspecialchars($success_message) ?>
            </div>
        <?php elseif (isset($error_message)): ?>
            <div class="alert alert-danger error-message">
                <?= htmlspecialchars($error_message) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label class="font-weight-bold">Select Status:</label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="site_status" value="enabled" id="enabled" <?= $site_status === 'enabled' ? 'checked' : '' ?>>
                    <label class="form-check-label" for="enabled">Enable</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="site_status" value="disabled" id="disabled" <?= $site_status === 'disabled' ? 'checked' : '' ?>>
                    <label class="form-check-label" for="disabled">Disable</label>
                </div>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Save Status</button>
        </form>
        
        <div class="form-group mt-4">
            <label class="font-weight-bold">Toggle Dark Mode:</label>
            <button id="darkModeToggle" class="btn btn-secondary btn-block">Enable Dark Mode</button>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        const toggleButton = document.getElementById('darkModeToggle');
        let darkMode = false;

        toggleButton.addEventListener('click', () => {
            darkMode = !darkMode;
            document.body.classList.toggle('dark-mode', darkMode);
            toggleButton.textContent = darkMode ? 'Disable Dark Mode' : 'Enable Dark Mode';
        });
    </script>
</body>
</html>
